/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.QueryReply;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.Trace;

class QueryMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFQMST";
    private static final String TRACE_MASKF = "XRBFQMSF";
    private static final String TRACE_MASKD = "XRBFQMSD";
    private static final long serialVersionUID = 8604775869854091939L;
    private RbfRequestId requestId;

    QueryMsg(RbfRequestId requestId) {
        this.requestId = requestId;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfReply process(MachineId sender2, int protocol) {
        QueryReply reply;
        block10: {
            Trace.trace(TRACE_MASKT, "-> process()");
            reply = null;
            try {
                RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                RbfRequest request = rhMgr.getRequest(this.requestId);
                if (request != null) {
                    RequestTrackingData trackingData;
                    RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
                    synchronized (requestTrackingData) {
                        int state = trackingData.getState();
                        reply = state == 4 ? new QueryReply(this.requestId, 0) : (state == 6 ? new QueryReply(this.requestId, 2) : (state == 8 ? new QueryReply(this.requestId, 4) : (state == 12 ? new QueryReply(this.requestId, 8) : (state == 20 ? new QueryReply(this.requestId, 12) : new QueryReply(this.requestId, 16)))));
                        break block10;
                    }
                }
                RbfHandleResponse handleResponse = rhMgr.getHandleResponse(this.requestId);
                if (handleResponse != null) {
                    try {
                        reply = new QueryReply(this.requestId, 16, handleResponse);
                    }
                    catch (PersistenceException pe) {
                        reply = new QueryReply(this.requestId, 16);
                    }
                } else {
                    reply = new QueryReply(this.requestId, 16);
                }
            }
            catch (PersistenceNotInitializedException pnie) {
                reply = new QueryReply(this.requestId, 16);
            }
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[QueryMsg: reqId=" + this.requestId + "]");
        return sb.toString();
    }
}

